program dotNetApp;

uses
  System.Windows.Forms,
  Win32DLLImport in 'Win32DLLImport.pas';

type
  TfrmPInvoke = class(Form)
    btnDoSomething1: Button;
    btnDoSomething2: Button;
    btnDoSomething3: Button;
    procedure btnDoSomething1Click(Sender: TObject; Args: EventArgs);
    procedure btnDoSomething2Click(Sender: TObject; Args: EventArgs);
    procedure btnDoSomething3Click(Sender: TObject; Args: EventArgs);
  public
    constructor Create;
  end;

{ TfrmPInvoke }

procedure TfrmPInvoke.btnDoSomething1Click(Sender: TObject;
  Args: EventArgs);
begin
  DoSomething(987654321);
end;

procedure TfrmPInvoke.btnDoSomething2Click(Sender: TObject;
  Args: EventArgs);
begin
  DoSomethingElse('This is an ANSI string');
end;

procedure TfrmPInvoke.btnDoSomething3Click(Sender: TObject;
  Args: EventArgs);
begin
  DoSomethingElseW('This is a Unicode string');
end;

constructor TfrmPInvoke.Create;
begin
  inherited;
  Width := 480;
  Height := 90;
  StartPosition := FormStartPosition.CenterScreen;
  Text := '.NET App Using Win32 DLL Exports';
  FormBorderStyle := FormBorderStyle.FixedSingle;
  MinimizeBox := False;
  MaximizeBox := False;
  btnDoSomething1 := Button.Create;
  with btnDoSomething1 do
  begin
    Text := 'Do Something';
    SetBounds(16, 16, 137, 33);
    Parent := Self;
    Add_Click(btnDoSomething1Click);
  end;
  btnDoSomething2 := Button.Create;
  with btnDoSomething2 do
  begin
    Text := 'Do Something Else (ANSI)';
    SetBounds(168, 16, 137, 33);
    Parent := Self;
    Add_Click(btnDoSomething2Click);
  end;
  btnDoSomething3 := Button.Create;
  with btnDoSomething3 do
  begin
    Text := 'Do Something Else (Unicode)';
    SetBounds(320, 16, 137, 33);
    Parent := Self;
    Add_Click(btnDoSomething3Click);
  end;
end;

begin
  Application.Run(TfrmPInvoke.Create);
end.
